
/*
   Just a sample adapted (quickly) from another program in
   tclbin(test) ... not something to be kept necessarily...
   (there is still some printfs and other numerical recipes kludges...)

*/

static char *rcsid="$Id: mathfft.c,v 1.2 1995/10/19 15:44:47 dl Exp $";
 
/*
 * FFT algorithm specialized for several calls with same
 * number of samples.
 *
 * Based on
 *  "Numerical Recipes, Press, Flannery, Teukolsky et Vetterling)"
 * algorithm, by DL, 31/12/1991
 *
 *
 */
#include "appli.h"
#include <stdlib.h>

#define D_PI	6.28318530717959


static int init_fft _ANSI_ARGS_((int nbech));
static int reordfft _ANSI_ARGS_((double *data));
static int cmplxfft _ANSI_ARGS_((double *data,int isign));
static int free_fft _ANSI_ARGS_((void));
static int dsp _ANSI_ARGS_((double *d1,double *d2,int n,double *dsp1,double *dsp2,double *fft));


/* 
 * Local variables to all functions for the FFT module :
 *
 */
static int	nbr_ech=0,	/* nombre d'echantillons 		*/
  		nbr_bit=0,	/* nombre de bits (nbr_ech=2^nbr_bit) 	*/
  		nbr_inv=0,	/* nombre d'inversions 			*/
 		*tabinv=NULL;	/* tableau des inversions a realiser 	*/

/* Initialisation function of the number of samples */
static int init_fft(param_nbr_ech)
int	param_nbr_ech;
{
  int		bits;
  int		i,j,m,n,nn,*pi,ni;
  if (param_nbr_ech==nbr_ech)	
    return(OK);
  free_fft();
  nbr_ech=n=param_nbr_ech;
  /* test power of 2 : */
  nbr_bit=bits = (int) ( log ((double)n)/log(2.) +0.5  );
  if (n!=(int)(pow(2.,(double)bits)+0.5))
    {
      fprintf(stderr,
	      "ERR init_fft: %d is not a power of 2\n",n);
      return(PB);
    }
  pi=tabinv=(int*)ckalloc(n*sizeof(int)); /* (n/2) couple d'entiers au max */
  if (!pi)
    {
      fprintf(stderr,"ERR fft_init: unable to alloc memory\n\n");
      exit(-1);
    }
  
  /* construction du tableau de re-arengement par Bit reversal : */
  nn=n/2;
  j=0;
  ni=0;
  for (i=0;i<n;i++)
    {
      if (j>i)
    	{
	  ni++;
	  *pi++=i;
	  *pi++=j;
    	}
      for (m=nn; (j>=m) && (m>0) ; m/=2) j-=m;
      j+=m;
    } 
  nbr_inv=ni;
  
  /* multiplication par 2 (indice sur complx=2*reel) : */
  for (i=2*nbr_inv,pi=tabinv;i--;)
    *pi++ *= 2;
  
  return(OK);
}


/* reordennancement : */
static int	reordfft(data)
     double *data;
{
  int i,*ptabi=tabinv;
  double *pdta1,*pdta2,tempr,tempi;
  for (i=nbr_inv;i--;)
    {
      tempr = *(pdta1=data + (*ptabi++));
      tempi = *(pdta1+1);
      *pdta1++ = *(pdta2=data + (*ptabi++)) ;
      *pdta1   = *(pdta2+1) ;
      *pdta2++ = tempr;
      *pdta2   = tempi;
    }
  return(OK);
}

/* FFT complexe ou FFT inverse (selon isign) : */
static int	cmplxfft(data,isign)
     double	*data;
     int	isign;
{
  double tempr,tempi,wr,wi;
  int	i,m,n,mmax;
  double	*pdj,*pdi,wpr,wpi,wtemp,theta;
  int	istep;
  
  reordfft(data);
  n=2*nbr_ech;
  for (mmax=2; n>mmax; mmax=istep)
    {
      istep=2*mmax;
      theta=D_PI/(isign*mmax);
      wpr=sin(0.5*theta);
      wpr*=-2.*wpr;	/* wpr = -2 (sin(theta/2))^2 */
      wpi=sin(theta);
      wr=1.;
      wi=0.;
      for (m=1;m<=mmax;m+=2)
	{
	  for (i=m; i<=n; i+=istep)
	    {
	      pdj=(pdi=data+i)+mmax;
	      tempr=wr * (*(pdj-1))  - wi * (*(pdj))  ;
	      tempi=wr * (*(pdj))   + wi * (*(pdj-1)) ;
	      *pdj--  = *(pdi)   -tempi;
	      *pdj    = *(pdi-1) -tempr;
	      *pdi--  += tempi;
	      *pdi    += tempr;
	    }
	  wtemp=wr;
	  wr=wr*wpr-wi*wpi+wr;
	  wi=wi*wpr+wtemp*wpi+wi;
	}
    }
  return(OK);
}

/*	Fonction de liberation memoire : */
static int	free_fft()
{
  if (tabinv)
    {
      ckfree((void *)tabinv);
      tabinv=NULL;
      nbr_ech=nbr_inv=nbr_bit=0;
    }
  return(OK);
}


/* Calcul de la DSP de 2 tableaux de valeurs reelles */
/* renvoie 2 tableaux de dimensions n/2 */
/* ainsi que l'energie moy du signal */

/*
  Proprietes de la dsp :

   2n                                n
  Somme( ( data(i) - moy ) ^ 2 ) = Somme ( dsp(i) )
    1                                1

<=>

   2n                      n
  Somme( data(i) ^ 2 ) = Somme ( dsp(i) ) + moy^2 * 2 * n
    1                      1

avec 2n=nbre d'echantillons du signal
      n=nbre d'echantillons de la dsp

*/


static int dsp(data1,data2,n,dsp1,dsp2,fft)
tp_double	data1,data2,dsp1,dsp2,fft;
int		n;
{
  int i,n2=n/2;
  tp_double p1,p2,pv,pvn;
  double	v,vn,r,rn,a,b,divisor,moy1,moy2;
  if ( n != nbr_ech ) {
      if (init_fft(n)!=OK) return PB;
  }
  for (i=n,p1=data1, p2=data2, pv=fft; i--; ) {
      *pv++=*p1++;
      *pv++=*p2++;
  }
  cmplxfft(fft,1);
  pv=fft;
  divisor=1./((double)n);

  moy1= (*pv++)*divisor ;
  moy2= (*pv++)*divisor ;

  divisor *= .5;     	/* 2* pour repliement, /4 pour extraction algo -> /2 */
  pvn=fft+2*n-1;
  p1=dsp1;
  p2=dsp2;
  for (i=n2-1;i--;) {
      r=*pv++;
      v=*pv++;
      vn=*pvn--;
      rn=*pvn--;
      a=r+rn;
      b=v-vn;
      *p1++= (a*a + b*b)*divisor;
      a=r-rn;
      b=v+vn;
      *p2++= (a*a + b*b)*divisor;
  }
  r=*pv;
  *p1=r*r*divisor;
  v=*pvn;
  *p2=v*v*divisor;
  return(OK);
}




/*
 *
 *	Wrapper for dsp function
 *
 */
int  Math_DspCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Client Data (unused) */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings.    */
{
  int		sd;
  Bin_Object	*object;
  tp_double	data1,
		data2,
		dsp1,
		dsp2,
		work;
  int		n,nbits;

  sd = sizeof(double);

  if ( argc!=7 ) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " array1 array2 nbrsample dsp1 dsp2 work\"", (char *)NULL);
      return TCL_ERROR;
  }

  if (Tcl_GetInt(interp,argv[3],&n)==TCL_ERROR) return TCL_ERROR;
  nbits = (int) ( log ((double)n)/log(2.) +0.5  );
  if (n!=(int)(pow(2.,(double)nbits)+0.5)) {
      Tcl_AppendResult(interp,ltoa(n)," is not a power of 2!");
      return TCL_ERROR;
  }
  
  if (!(object=Bin_GetObjectAndCheck(interp,argv[1],"double*"))) return TCL_ERROR;
  data1 = (double *)object->data;
  if( n!=object->size/sd ) {
    Tcl_AppendResult(interp,"incorrect size for array1 (should be n)",NULL);
    return TCL_ERROR;
  }

  if (!(object=Bin_GetObjectAndCheck(interp,argv[2],"double*"))) return TCL_ERROR;
  data2 = (double *)object->data;
  if( n!=object->size/sd ) {
    Tcl_AppendResult(interp,"incorrect size for array2 (should be n)",NULL);
    return TCL_ERROR;
  }

  if (!(object=Bin_GetObjectAndCheck(interp,argv[4],"double*"))) return TCL_ERROR;
  dsp1 = (double *)object->data;
  if( n/2!=object->size/sd ) {
    Tcl_AppendResult(interp,"incorrect size for dsp1 (should be n/2)",NULL);
    return TCL_ERROR;
  }

  if (!(object=Bin_GetObjectAndCheck(interp,argv[5],"double*"))) return TCL_ERROR;
  dsp2 = (double *)object->data;
  if( n/2!=object->size/sd ) {
    Tcl_AppendResult(interp,"incorrect size for dsp2 (should be n/2)",NULL);
    return TCL_ERROR;
  }

  if (!(object=Bin_GetObjectAndCheck(interp,argv[6],"double*"))) return TCL_ERROR;
  work = (double *)object->data;
  if( object->size/sd < 2*n) {
    Tcl_AppendResult(interp,"incorrect size for w (should be 2*n)",NULL);
    return TCL_ERROR;
  }

  if (dsp(data1,data2,n,dsp1,dsp2,work)!=OK) {
    Tcl_AppendResult(interp,"error in dsp",NULL);
    return TCL_ERROR;
  }
  return TCL_OK;
}


/*
 *
 *	Wrapper for Complex Fft function
 *
 */
int  Math_FFTCmd(dummy, interp, argc, argv)
    ClientData dummy;			/* Client Data (unused) */
    Tcl_Interp *interp;			/* Current interpreter. */
    int argc;				/* Number of arguments. */
    char **argv;			/* Argument strings.    */
{
  Bin_Object	*object;
  tp_double	data1;
  int		isign,n;

  if ( argc<2 || argc>3 ) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " cplxSrcRes ?inverse?\"", (char *)NULL);
      return TCL_ERROR;
  }

  
  if (!(object=Bin_GetObjectAndCheck(interp,argv[1],"complex*"))) return TCL_ERROR;
  data1 = (double *)object->data;
  n=object->size/(2*sizeof(double));

  if ( n != nbr_ech ) {
      if (init_fft(n)!=OK) {
	  Tcl_AppendResult(interp, "error while initialising fft",NULL);
	  return TCL_ERROR;
      }
  }

  if (argc>3) isign=-1;
  else isign=1;

  if (cmplxfft(data1,isign)!=OK) {
    Tcl_AppendResult(interp,"error in complexfft",NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}
