/* $Id: md5.h,v 1.2 1996/05/10 16:50:54 dl Exp $
 */

#ifndef MD5_H
#define MD5_H

#ifdef HAVE_CONFIG_H
#include "binconf.h"
#endif

#include "tcl.h"

/* most modern machine should have 32 bits ints 
 * (some configure option should be added)
 */
typedef unsigned int uint32;

struct Bin_MD5Context {
	uint32 buf[4];
	uint32 bits[2];
	unsigned char in[64];
};

void Bin_MD5Init _ANSI_ARGS_((struct Bin_MD5Context *context));
void Bin_MD5Update _ANSI_ARGS_((struct Bin_MD5Context *context, 
			   unsigned char const *buf,
	       unsigned len));
void Bin_MD5Final _ANSI_ARGS_((unsigned char digest[16], 
			   struct Bin_MD5Context *context));
void Bin_MD5Transform _ANSI_ARGS_((uint32 buf[4], uint32 const in[16]));


#endif /* !MD5_H */
